<?php
if (!function_exists('newsday_theme_enqueue_styles')) {
    add_action('wp_enqueue_scripts', 'newsday_theme_enqueue_styles');

    function newsday_theme_enqueue_styles()
    {
        $newsday_version = wp_get_theme()->get('Version');
        $min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
        $parent_style = 'morenews-style';
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap' . $min . '.css');
        wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
        wp_enqueue_style(
            'newsday',
            get_stylesheet_directory_uri() . '/style.css',
            array('bootstrap', $parent_style),
            wp_get_theme()->get('Version')
        );

        // Enqueue RTL Styles if the site is in RTL mode
        if (is_rtl()) {
            wp_enqueue_style(
                'morenews-rtl',
                get_template_directory_uri() . '/rtl.css',
                array($parent_style),
                $newsday_version
            );
        }
    }
}

// Set up the WordPress core custom background feature.
add_theme_support('custom-background', apply_filters('newsday_custom_background_args', array(
    'default-color' => 'f7f7f7',
    'default-image' => '',
)));


function newsday_filter_default_theme_options($defaults)
{

    $defaults['show_popular_tags_section']  = 1;
    $defaults['select_popular_tags_mode']  = 'category';
    $defaults['site_title_font_size'] = 48;
    $defaults['site_title_uppercase']  = 0;
    $defaults['show_primary_menu_desc']  = 0;
    $defaults['select_header_image_mode']  = 'above';
    $defaults['disable_header_image_tint_overlay']  = 1;
    $defaults['flash_news_title'] = __('Breaking News', 'newsday');
    $defaults['aft_custom_title']           = __('Watch', 'newsday');
    $defaults['select_main_banner_layout_section'] = 'layout-5';
    $defaults['select_main_banner_order'] = 'order-1';
    $defaults['select_update_post_filterby'] = 'cat';
    $defaults['list_post_date_author_setting'] = 'show-date-author';
    $defaults['secondary_color'] = '#F43776';
    $defaults['global_show_min_read'] = 'no';
    $defaults['frontpage_content_type']  = 'frontpage-widgets-and-content';
    $defaults['main_latest_news_section_title'] = __('Recommended', 'newsday');
    $defaults['main_popular_news_section_title'] = __('Popular', 'newsday');
    $defaults['main_update_news_section_title'] = __('Archive', 'newsday');
    $defaults['featured_news_section_title'] = __('Featured News', 'newsday');
    $defaults['show_featured_post_list_section']  = 1;
    $defaults['featured_post_list_section_title_1']           = __('General', 'newsday');
    $defaults['featured_post_list_section_title_2']           = __('Opinion', 'newsday');
    $defaults['featured_post_list_section_title_3']           = __('More', 'newsday');
    return $defaults;
}
add_filter('morenews_filter_default_theme_options', 'newsday_filter_default_theme_options', 1);
